	define(['app', 'page_service', 'authentication_service'], function (app, global, authenticationService) {
	"use strict";
	app.directive('menuInclude', function () {
		return {
			replace: true,
			restrict: 'A',
			templateUrl: "src/container/components/menu/menu_template.html",
			controller: function ($scope, $rootScope, $q, $http, $window, $timeout, $modal, $state, $filter, pageService, authenticationService, snapRemote, focusService) {
				
				var closeFocusHelper;
				$scope.showSide = function (side) {					
					return $scope.snapper.state().state === side || $scope.snapper.state().info.opening === side;
				};
				snapRemote.getSnapper().then(function (snapper) {
					snapper.on('animated', function () {
						$timeout(function(){
							switch (snapper.state().state) {
								case "left":
                                    focusService.focusElement(angular.element('.snap-drawer-left .iOS-VO-overlap-accessible.panel-title'), true);
                                    $scope.applyAriaLabel('left', 'expanded');
								    break;
								case "right":
                                    focusService.focusElement(angular.element('.snap-drawer-right .iOS-VO-overlap-accessible.panel-title'), true);
                                    $scope.applyAriaLabel('right', 'expanded');
                                    angular.element($window).trigger('resize');
									break;
							}
						});
					});
					snapper.on('open', function() {
						angular.element('#main-content-body').attr('aria-hidden', 'true');
						closeFocusHelper = "main";
					});
					snapper.on('close', function() {
                        angular.element('#main-content-body').attr('aria-hidden', 'false');
                        $scope.applyAriaLabel(snapper.state().state, 'collapsed');
						if (closeFocusHelper === "main") {
							focusService.focusMain();
						}
					});
					$scope.snapper = snapper;
				});

				var statesList = $state.get();
				$scope.navItems = $filter('orderBy')(statesList.filter(function(val){
					return val.appNavIndex > 0;
				}), "appNavIndex").map(function(val){
					val.data.id = val.data.moduleName.replace(/\s/g, "");
					return val;
				});

				$http.get('src/container/components/menu/user-menu-items.json')
					.then(function (menuItems) {
						$scope.userItems = menuItems.data.menuItems;

						$timeout(function () {
							angular.element($window).trigger('resize');
						});
					});

				angular.element($window).resize(function () {
					resizeList(angular.element('div[snap-drawer=right]'));
				});

				var isAuthenticated = authenticationService.isAuthenticated();
				$scope.authenticationFilter = function (menuItem) {
					if ($state.current.module === "preventNavigation" && $scope.navItems.indexOf(menuItem) !== -1) {
						return false;
					}
					
					if (menuItem.data && menuItem.data.requiresAuth === true || menuItem.requiresAuth === true) {
						// when user is on main.initial-settings state, the menu / nav items that appear should mimic what user sees on splash page when
						// unauthenticated, except logout is still available, since main.initial-settings is an authenticated state
						if ($state.current.name.indexOf('main.initial-settings') !== -1 && menuItem.id !== "logout") {
							return false;
						} else {
							return isAuthenticated;
						}
					}

					if (menuItem.data && menuItem.data.requiresAuth === false || menuItem.requiresAuth === false) {
						return !isAuthenticated;
					}

					return true;
				};

				function resizeList(listContainer) {
					var windowHeight;

					windowHeight = window.innerHeight;

					var totalListHeight = 0;

					totalListHeight += listContainer.find('.panel-header').outerHeight();
					listContainer.find('ul').each(function (index, element) {
						totalListHeight += angular.element(element).outerHeight(false);
					});

					var margin = windowHeight - totalListHeight;
					if (margin < 0) {
						margin = 0;
					}

					listContainer.find('ul').first().css('margin-bottom', margin + 'px');
				}

				$scope.closeMenu = function () {
					angular.element('#main-content-body').attr('aria-hidden', 'false');
					closeFocusHelper = "main";
                };
        
                $scope.applyAriaLabel = function (side, state) {
                    switch(side) {
                        case "left":
                          angular.element('#left-menu-app-options').attr('aria-label', state === 'expanded' ? 'app options menu expanded' : 'app options menu collapsed');
                          break;
                        case "right":
                          angular.element('#right-user-menu-options').attr('aria-label', state === 'expanded' ? 'user menu expanded' : 'user menu options collapsed');
                          break;
                    }
                };

				$scope.openLink = function (link) {
					switch (link) {
						case "logout":
							authenticationService.gotoLogoutWithRedirect();
							break;
						case "login":
							authenticationService.authenticate();
							break;
						case "launchpad":
							pageService.redirectToLaunchpad();
							break;
					}
				};

				$scope.openModal = function (item) {
					var modalInfo = item.modal,
						modalInstance = $modal.open({
							windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
							templateUrl: modalInfo.templateUrl,
							controller: modalInfo.controller
						});

					modalInstance.result.finally(function () {
						focusService.focusElement(angular.element('button[id=' + item.id + ']'));
					});
				};

				$scope.openSubApp = function (state, params) {
					$state.go(state.name, params);
					closeFocusHelper = "section";
				};

				$scope.isSelected = function (item) {
					return $state.includes(item.name);
				};
			}
		};
	});
});